function [full_data,ch_ord,dist_termi,lum_termi] = preclassify(predata,punc_data,ch_num)
%A Little function that takes the data generated by by all of the punc
%functions and prepares them for classification.
%Synatax:   [full_data,distance,lum] = punc2mat(punc_data);
%Input:     punc_data = data structure created by punc_data
%           predata = data from punc_distill_lite.
%           ch_num = the number of channels minus ori and termi
%
%Output:    dist_termi = structure of distance matrices. distance(x).ch
%                   x = # of channels.  For distance(1).ch = a cell array,
%                   where the z is # of channels.  On x: Index, vertex, 2nd
%                   vertex, distance.  x y form an array.
%           ch_ord = the channel order of appearance in the data set, after
%                   termi.
%           full_data = data ready for classification, with distances for
%                   both pre and post.
%           lum_termi = the luminance value for the vertices, matches dist and
%                   vector data structure.
%           Note: cases were angle data is NaN is when the dot product and
%           the magnitudes of the base vectors are 0, essentially meaning
%           the two points are right on top of one another.  Might need to
%           deal with that at some point.

%lets get the distance matrices done.
%h = waitbar(0,['Data Sets Analyzed: ',punc_data(1).filenames{1}],'position',[20 300 275 50]);    %initialize progress bar.
%pull out some useful info
nrst_only = punc_data(1).nrst_only;
termi = punc_data(1).termi;

%create a temporary data structure for the termi distance structure, this
%is for looking at the post synaptic side of the synapse during
%classification
i = termi;
try
    chan = size(punc_data(i).dist_verti,3);     %number of channels
    verti = size(punc_data(i).dist_verti,1);    %number of vertices
catch
    chan = size(punc_data(i).sl_dist,3);
    verti = size(punc_data(i).sl_dist,1);
end

%begin parallelization
%matlabpool      %initiate threads

parfor j = 1:chan %step through the number of comparision channels.
    if nrst_only
        if ~isempty(cell2mat(punc_data(i).dist_verti(:,:,j)))   %proceed if this channel have values
            dist_tmp = [];
            lum_tmp = [];
            for k = 1:verti   %step through vertices of curr channel
                %pull out and create a array of data for each vertices.
                curr_tmp = horzcat(repmat(k,size(punc_data(i).verti_match{k,1,j},1),1),punc_data(i).verti_match{k,1,j},...
                    repmat(punc_data(i).v_match_lum{k,1,i},size(punc_data(i).verti_match{k,1,j},1),1),punc_data(i).closest_pt{k,1,j},...
                    punc_data(i).dist_verti{k,1,j});
                curr_lum_tmp = horzcat(repmat(k,size(punc_data(i).verti_match{k,1,j},1),1),punc_data(i).verti_match{k,1,j},...
                    repmat(punc_data(i).v_match_lum{k,1,i},size(punc_data(i).verti_match{k,1,j},1),1),punc_data(i).closest_pt{k,1,j},...
                    punc_data(i).closest_pt_lum{k,1,j});
                %now form the larger arrays
                dist_tmp = vertcat(dist_tmp,curr_tmp);
                lum_tmp = vertcat(lum_tmp,curr_lum_tmp);
            end
            %clear curr_tmp curr_lum_tmp
            curr_tmp = []; curr_lum_tmp = [];
            %one array is ready for output
            dist_termi{1,1,j} = dist_tmp;
            lum_termi{1,1,j} = lum_tmp;
        end
    else
        if ~isempty(cell2mat(punc_data(i).sl_dist(:,:,j)))   %proceed if this channel have values
            dist_tmp = [];
            lum_tmp = [];
            for k = 1:verti   %step through vertices of curr channel
                %pull out and create a array of data for each vertices in the short list.
                sl_curr_tmp = horzcat(repmat(k,size(punc_data(i).sl_verti_match{k,1,j},1),1),punc_data(i).sl_verti_match{k,1,j},...
                    repmat(punc_data(i).sl_v_match_lum{k,1,i},size(punc_data(i).sl_verti_match{k,1,j},1),1),punc_data(i).short_list{k,1,j},...
                    punc_data(i).sl_dist{k,1,j});
                sl_curr_lum_tmp = horzcat(repmat(k,size(punc_data(i).sl_verti_match{k,1,j},1),1),punc_data(i).sl_verti_match{k,1,j},...
                    repmat(punc_data(i).sl_v_match_lum{k,1,i},size(punc_data(i).sl_verti_match{k,1,j},1),1),punc_data(i).short_list{k,1,j},...
                    punc_data(i).short_list_lum{k,1,j});
                dist_tmp = vertcat(dist_tmp,sl_curr_tmp);
                lum_tmp = vertcat(lum_tmp,sl_curr_lum_tmp);
            end
            %clear curr_tmp curr_lum_tmp
            sl_curr_tmp = []; sl_curr_lum_tmp = [];
            %one array is ready for output
            dist_termi{1,1,j} = dist_tmp;
            lum_termi{1,1,j} = lum_tmp;
        end
    end
end
%clear the tmp files
clear dist_tmp lum_tmp curr_tmp curr_lum_tmp sl_curr_tmp sl_curr_lum_tmp

%now prep the punc_distill data for classification
full_data = predata(:,1:23);    %in the beginning all was the same...ok just partially
for i = 1:ch_num    %go through the number of accessory channels
    %full_data = horzcat(full_data,single(inf(size(predata,1),2)));  %add the new rows
    curr_col = 13+((i-1)*11);   %get the current start column
    curr_ch = predata(1,curr_col);     %get the channel we want to look at for now
    add_tmp = [];
    parfor j = 1:size(predata,1)   %go through all of the rows of the predata structure
        vertex1 = predata(j,8:10);  %the termi vertex
        vertex2 = predata(j,curr_col+1:curr_col+3); %the accessory vertex
        [ma_dist,ma_lum] = match_data(vertex1,vertex2,dist_termi{:,:,curr_ch},lum_termi{:,:,curr_ch});
        add_tmp = vertcat(add_tmp,[ma_dist ma_lum]);   %post distance post brightness
    end
    full_data = horzcat(full_data,add_tmp);
    if i~=ch_num    %if not the last time through
        next_col = 13+(i*11);   %get the current start column
        full_data = horzcat(full_data,predata(:,next_col:next_col+10)); %put on the preserved data from the next channel.
    end
    ch_ord(1,i) = curr_ch;      %store the order of channels present inthe data set.
end

%closing time
%matlabpool close

%--------------------------------------------------------------------------
%subfunction to find a corresponding distance or luminance in the termi
%dataset from a vertex in the ori data set.
function [ma_dist,ma_lum] = match_data(vertex1,vertex2,dist_data,lum_data)
ma_dist = single(NaN);      %the output value will be NaN if the vertex cannot be found.
ma_lum = single(NaN);
%vertex2 = vertex2.*scale_factor;      %if the vertices are scaled, we need to scale them to find the data
[y,x] = find(dist_data(:,2)==repmat(vertex1(1),size(dist_data,1),1)&...
    dist_data(:,3)==repmat(vertex1(2),size(dist_data,1),1)&...
    dist_data(:,4)==repmat(vertex1(3),size(dist_data,1),1)&...
    dist_data(:,6)==repmat(vertex2(1),size(dist_data,1),1)&...
    dist_data(:,7)==repmat(vertex2(2),size(dist_data,1),1)&...
    dist_data(:,8)==repmat(vertex2(3),size(dist_data,1),1));
if ~isempty(y)  %if there is a value
    ma_dist = dist_data(y,9);
    ma_lum = lum_data(y,9);
end